# setup-aris.ps1
# Aris Windows Setup Script - Run as Administrator
# Right-click -> Run with PowerShell

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "       Aris Setup for Windows          " -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# Check if running as Administrator
$isAdmin = ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)
if (-not $isAdmin) {
    Write-Host "ERROR: Please run this script as Administrator!" -ForegroundColor Red
    Write-Host "Right-click the script and select 'Run with PowerShell' as Admin" -ForegroundColor Yellow
    Read-Host "Press Enter to exit"
    exit 1
}

# Step 1: Install PostgreSQL
Write-Host "[1/4] Installing PostgreSQL 16..." -ForegroundColor Green
$pgInstalled = Test-Path "C:\Program Files\PostgreSQL\16\bin\psql.exe"
if ($pgInstalled) {
    Write-Host "      PostgreSQL already installed, skipping." -ForegroundColor Yellow
} else {
    Write-Host "      Running PostgreSQL installer..." -ForegroundColor White
    Write-Host "      IMPORTANT: Remember the password you set for 'postgres' user!" -ForegroundColor Yellow
    Write-Host ""
    Start-Process -FilePath ".\postgresql-16.11-2-windows-x64.exe" -Wait
}

# Add PostgreSQL to PATH for this session
$env:Path += ";C:\Program Files\PostgreSQL\16\bin"

# Step 2: Install pgvector extension
Write-Host "[2/4] Installing pgvector extension..." -ForegroundColor Green
Copy-Item ".\vector.v0.8.1-pg16\lib\*" "C:\Program Files\PostgreSQL\16\lib\" -Force
Copy-Item ".\vector.v0.8.1-pg16\share\extension\*" "C:\Program Files\PostgreSQL\16\share\extension\" -Force
Write-Host "      pgvector files copied." -ForegroundColor Green

# Step 3: Create Aris database user
Write-Host "[3/4] Creating Aris database user..." -ForegroundColor Green
Write-Host ""
$pgPassword = Read-Host "Enter the password you set for postgres user during install"
$env:PGPASSWORD = $pgPassword

& "C:\Program Files\PostgreSQL\16\bin\psql.exe" -U postgres -c "CREATE USER aris WITH SUPERUSER PASSWORD 'aris123';" 2>$null
& "C:\Program Files\PostgreSQL\16\bin\psql.exe" -U postgres -c "CREATE EXTENSION IF NOT EXISTS vector;" 2>$null

# Step 4: Verify
Write-Host "[4/4] Verifying installation..." -ForegroundColor Green
$result = & "C:\Program Files\PostgreSQL\16\bin\psql.exe" -U postgres -c "SELECT extname FROM pg_extension WHERE extname = 'vector';" 2>&1
if ($result -match "vector") {
    Write-Host "      pgvector extension verified!" -ForegroundColor Green
} else {
    Write-Host "      Warning: Could not verify pgvector." -ForegroundColor Yellow
}

Write-Host ""
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "      Database Setup Complete!         " -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "Now install Aris by double-clicking:" -ForegroundColor White
Write-Host "  Aris Setup 0.2.1.exe" -ForegroundColor Yellow
Write-Host ""
Write-Host "If you see a SmartScreen warning, click:" -ForegroundColor White
Write-Host "  'More info' -> 'Run anyway'" -ForegroundColor Yellow
Write-Host ""
Read-Host "Press Enter to exit"
